﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    [Serializable]
    [XmlType(TypeName = "PatientIcon")]
    [DataContract(Name = "PatientIcon")]
    [KnownType(typeof(II))]
    public class PatientIcon
    {
        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 1)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag ids of patient.
        /// </summary>
        /// <value>
        /// The list icon flag ids of patient.
        /// </value>
        [XmlElementAttribute("IconFlagIds", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "IconFlagIds", Order = 2)]
        public List<int> IconFlagIds { get; set; }
    }
}
